%% connect_arduinostage
%> @file connect_arduinostage.m

%% Informationen zur Funktion
% Von Nikolas Arthkamp (11.2021)
% fuer: grbl-Version 1.1.
% Die Funktion benoetigt MATLAB R2019b oder neuer
% und versucht eine Verbindung zum grbl-Controller aufzubauen.
% Sie gibt den Status der Verbindung sowie der Bewegungsart als Rueckgabe
% vom Typ string an 1. und 2. Stelle aus. An 3. Stelle wird das erzeugte
% serialport-Objekt ausgegeben. Es ist zwingend erforderlich dieses
% auszulesen.

%% Funktion

%> @brief versucht eine Verbindung zum grbl-Controller aufzubauen
%> @param port
%> @retval ans_connection Status der Verbindung
%> @retval ans_bewegungsart Status der Bewegungsart
%> @retval serialport_object Serialportobjekt
function [ans_connection,ans_bewegungsart,serialport_object] = connect_arduinostage(port)
    
    %Kommunikation aufbauen und testen

    %Serielle Kommunikation aufbauen
    %Baudrate von grbl-Version 1.1 = 115200
    serialport_object = serialport(port, 115200);                    
    %muss min 0.3 sein --> 0.5 fuer Stabilitaet
    pause(0.5);                                                 

    %Terminator aendern
    %Terminator in grbl-Version 1.1: 'CR/LF'
    configureTerminator(serialport_object, 'CR/LF');                 
    %weitere Einstellungen (Hier gesetzte Einstellungen sind default und werden
    %nur gesetzt, um Fehler durch Aenderungen in den Matlab
    %default-Einstellungen zu vermeiden.)
    set(serialport_object,'DataBits',8);
    set(serialport_object,'Parity','none');
    set(serialport_object,'StopBits',1);
    set(serialport_object,'FlowControl','none');

    %Antwort bei Verbindungsaufbau auslesen und pruefen
    %wenn korrekt aufgebaut in grbl-Version 1.1
    ans1_soll = "Grbl 1.1h ['$' for help]";
    %grbl Anfangsnachricht hat 26 Zeichen
    ans1 = check_grbl_read(serialport_object,26);                    

    if ans1 == ans1_soll
        ans_connection = "grbl-Verbindung aufgebaut!";

        %inkrementelle Bewegung festlegen
        ans2_soll = "okok";
        %gcode: G91 --> inkrementelle Bewegung
        writeline(serialport_object,"G91");
        %Bestaetigung hat 8 Zeichen
        ans2 = check_grbl_read(serialport_object,8);
    
        if ans2 == ans2_soll
            ans_bewegungsart = "inkrementelle Bewegungsart festgelegt!";
        else
            ans_bewegungsart = "Festlegen der Bewegungsart fehlgeschlagen!";
            %Auslesen abgeschnittener Zeichen um zwischenspeicher des Controllers zu leeren
            check_grbl_read(serialport_object,20);           
        end
        
    else
        ans_connection = "grbl-Verbindung fehlgeschlagen!";
        ans_bewegungsart = "nicht moeglich!";
        
    end

end